require( "scripts/chocshopstyle.lua" );
require( "scripts/transitions.lua" );

kCheatFail      = 0;
kCheatPass      = 1;
kCheatMaster    = 2;
kCheatMoney     = 3;
kCheatGoto      = 4;
kCheatHighest   = 5;

CheatSmallFont = { edwardian_medium, 18, WhiteColor };
CheatButtonStyle = {
    font = CheatSmallFont,
    flags = kHAlignCenter + kVAlignCenter,
    graphics = App_StandardButtonGraphics,
};
CheatCheckStyle = {
    baseDir = "ui/buttons/",
    font = { edwardian_medium, 14, WhiteColor },
    flags = kHAlignLeft + kVAlignCenter,
    type = kToggle,
    scale = 0.80,
    assets = {
        default = {
            {state="default", file="cs_check2_off", anim=false},
            --{state="over", file="checkover", anim=false},
            {state="on", file="cs_check2_on", anim=false},
            --{state="on_over", file="checkdownover", anim=false},
        }
    }
};
MakeDialog{
    name = "cheats_achievements_dialog",
    VChooseAchievements{
        checkstyle = CheatCheckStyle,
        x = 273, y = 5, w = 415, h = 500,
        KSplit9Image{
            x = 0, y = 0, w = 415, h = 500,
            x1		= 40,
		    y1		= 40,
		    x2		= 40,
		    y2		= 40,
            image = "ui/backgrounds/split9_dialog_small",
        },
        RScrollable{
            name = "scroller",
            x = 5, y = 5, w = kMax - 10, h = kMax - 75,
            VSpriteWindow{
                name = "sprite_window",
                w = 405,
            },
            SetStyle(App_SliderStyle),
            TSlider{
				x = kMax - 30,
				y = 2,
				h = kMax-2,
				w = 25,
				name = "achievement_slider",
			},
        },
        SetStyle(CSOvalLightBlueButtonStyle);
        Button{
            name = "btn_acquire",
            x = 5, y = kMax - 75,
            --w = 115, h = 32,
            label = "#Acquire All",
            command = 
                function() 
                    PostMessage(CreateNamedMessage(kButtonPress, "btn_acquire"));
                end
        },
        Button{
            name = "btn_release",
            x = 105, y = kMax - 75,
            --w = 115, h = 32,
            label = "#Release All",
        },
        Button{
            name = "btn_notify",
            x = 200, y = kMax - 75,
            --w = 115, h = 32,
            label = "#Test Notify",
        },
        Button{
            x = kMax - 115, y = kMax - 75,
            --w = 115, h = 32,
            label = "#Close",
            command = 
                function()
                    CloseWindow();
                    --PostMessage( CreateNamedMessage( kCrossFadeOut, "CloseWindow();" ) );
                end
        },
    },
}
SetFocus("cheats_achievements_dialog");
--PostMessage( CreateNamedMessage( kCrossFadeIn, "" ) );
